#ifndef SON_H
#define SON_H

#include <AL/al.h>
#include <AL/alc.h>
#include <AL/alut.h>

#define TREESHOT 0
#define MONOSHOT 1
#define TURRETSHOT 2
#define DUALSHOT 3

#define MSL1 4
#define MSL2 4
#define MSL3 5
#define MSL4 6
#define MSL5 6

#define EXPLOJR 7

#define NBEXPLO 3
#define EXPLOENM 8
#define EXPLOMSL 11

#define IMPACTJ 14

class CSon
{
    private:
        unsigned char nbSon;
        ALuint *tabBuff;
        
        unsigned char srcPtr;
        unsigned char nbSource;
        ALuint *tabSrc;
        
        float pz;
        float zmax;
        
        float volume;
        
        //Le son du racteur est ici gr  part car il doit tre en mode LOOP
        ALuint sonReacteur;
        ALuint sourceReacteur;
        
    public:
        CSon();
        ~CSon();
        
        void loadSound();
        void initSources(unsigned char nbSource);
        void playSound(unsigned char id,float z,float vol=1.0);
        
        void setParam(float pz,float zmax);
        void setVolume(float volume);
        
        void playReacteurLoop();
        void pauseReacteurLoop();
        void stopReacteurLoop();
        
        void clear();
};

#endif
